//=============================================================================

#include "cinder/app/App.h"
#include "cinder/app/RendererGl.h"
#include "cinder/Color.h"
#include "cinder/gl/gl.h"
#include "cinder/Vector.h"

using namespace ci;
using namespace ci::app;
using namespace gl;

//-----------------------------------------------------------------------------

class CinderApp : public App
{
public:
   static void prepareSettings(Settings* settings);
   void setup() override;
   void update() override;
   void draw() override;
};

//-----------------------------------------------------------------------------

void CinderApp::prepareSettings(Settings* settings)
{
   settings->setTitle("Cinder 03 - Kreise zeichnen");
   settings->setResizable(false);
   settings->setWindowPos(1000, 200);
   settings->setWindowSize(640, 480);
   settings->setFrameRate(30.0f);
}

//-----------------------------------------------------------------------------

void CinderApp::setup()
{
}

//-----------------------------------------------------------------------------

void CinderApp::update()
{
}

//-----------------------------------------------------------------------------

void CinderApp::draw()
{
   clear(Color(0, 0, 0));

   color(Color(1.0f, 0.0f, 0.0f));
   drawSolidCircle(vec2(100.f, 100.f), 10);

   color(Color(0.0f, 1.0f, 0.0f));
   drawSolidCircle(vec2(150.f, 150.f), 20);

   color(Color(0.0f, 0.0f, 1.0f));
   drawSolidCircle(vec2(200.f, 200.f), 30);
}

//-----------------------------------------------------------------------------

CINDER_APP(CinderApp, RendererGl(), &CinderApp::prepareSettings)
