//=============================================================================

#include "cinder/app/App.h"
#include "cinder/app/RendererGl.h"
#include "cinder/Color.h"
#include "cinder/gl/gl.h"
#include "cinder/Vector.h"
#include "Ship.h"

using namespace ci;
using namespace ci::app;
using namespace gl;

//-----------------------------------------------------------------------------

class CinderApp : public App
{
public:
   static void prepareSettings(Settings* settings);
   void setup() override;
   void update() override;
   void draw() override;
};

//-----------------------------------------------------------------------------

void CinderApp::prepareSettings(Settings* settings)
{
   settings->setTitle("Cinder 04 - Raumschiffe zeichnen");
   settings->setResizable(false);
   settings->setWindowPos(1000, 300);
   settings->setWindowSize(640, 480);
   settings->setFrameRate(30.0f);
}

//-----------------------------------------------------------------------------

void CinderApp::setup()
{
}

//-----------------------------------------------------------------------------

void CinderApp::update()
{
}

//-----------------------------------------------------------------------------

void CinderApp::draw()
{
   clear(Color(0, 0, 0));

   const Color ship_color(0.0f, 1.0f, 1.0f);

   Ship::Draw(vec2(100.f, 100.f), vec2(-0.7f, -0.7f), ship_color);
   Ship::Draw(vec2(150.f, 100.f), vec2(+0.0f, -1.0f), ship_color);
   Ship::Draw(vec2(200.f, 100.f), vec2(+0.7f, -0.7f), ship_color);
   Ship::Draw(vec2(100.f, 150.f), vec2(-1.0f, +0.0f), ship_color);
   Ship::Draw(vec2(200.f, 150.f), vec2(+1.0f, +0.0f), ship_color);
   Ship::Draw(vec2(100.f, 200.f), vec2(-0.7f, +0.7f), ship_color);
   Ship::Draw(vec2(150.f, 200.f), vec2(+0.0f, +1.0f), ship_color);
   Ship::Draw(vec2(200.f, 200.f), vec2(+0.7f, +0.7f), ship_color);
}

//-----------------------------------------------------------------------------

CINDER_APP(CinderApp, RendererGl(), &CinderApp::prepareSettings)
