//=============================================================================

#include "cinder/gl/gl.h"
#include "Ship.h"

using namespace ci;
using namespace gl;

//-----------------------------------------------------------------------------

float Ship::sScreenWidth = 0.f;
float Ship::sScreenHeigth = 0.f;

const Color Ship::sColor(0.0f, 1.0f, 1.0f);

//-----------------------------------------------------------------------------

Ship::Ship()
 : mLocation(vec2(sScreenWidth/2, sScreenHeigth/2)), 
   mDirection(vec2(0.f, -1.f)),
   mSpeed(0.0f)
{
}

//-----------------------------------------------------------------------------

void Ship::rotate(float degree)
{
   mDirection = glm::rotate(mDirection, degree/360.0f*3.1415f);
}

//-----------------------------------------------------------------------------

void Ship::accelerate(float accel)
{
   mSpeed += accel;
}

//-----------------------------------------------------------------------------

void Ship::update()
{
   if (mSpeed<0.5f && mSpeed>-0.5f)
   {
      mSpeed = 0.0f;
      return;
   }

   mLocation += mDirection * mSpeed;
   mSpeed *= 0.92f;

   if (mLocation[0]<0.0f)
   {
      mLocation[0] += sScreenWidth;
   }
   else if (mLocation[0]>=sScreenWidth)
   {
      mLocation[0] -= sScreenWidth;
   }

   if (mLocation[1]<0.0f)
   {
      mLocation[1] += sScreenHeigth;
   }
   else if (mLocation[1]>=sScreenHeigth)
   {
      mLocation[1] -= sScreenHeigth;
   }
}

//-----------------------------------------------------------------------------

void Ship::draw() const
{
   Draw(mLocation, mDirection, sColor);
}

//-----------------------------------------------------------------------------

void Ship::Draw(const vec2& location, const vec2& direction, const Color& color)
{
   vec2 loc1 = location + direction * 8.0f;
   vec2 loc3 = location + direction * 5.0f;
   vec2 loc5 = location;
   vec2 loc7 = location - direction * 7.0f;

   gl::color(color);
   drawSolidCircle(loc1, 1);
   drawSolidCircle(loc3, 3);
   drawSolidCircle(loc5, 5);
   drawSolidCircle(loc7, 7);
}
