//=============================================================================

#ifndef TORPEDO_H
#define TORPEDO_H

#include <memory>
#include "cinder/Color.h"
#include "cinder/Vector.h"

//-----------------------------------------------------------------------------

class Torpedo
{
public:
   static float sScreenWidth;
   static float sScreenHeigth;

   explicit Torpedo(const ci::vec2& location, const ci::vec2& direction);

   void update();
   void draw() const;

   static void Draw(const ci::vec2& location, const ci::Color& color);

   static float Radius() { return 2.0f; }
   static float Size() { return 2*Radius(); }

private:
   static const ci::Color sColor;
   ci::vec2 mLocation;
   ci::vec2 mDirection;
};

using TorpedoPtr = std::shared_ptr<Torpedo>;

//-----------------------------------------------------------------------------

#endif
