//=============================================================================

#include "cinder/gl/gl.h"
#include "Torpedo.h"

using namespace ci;
using namespace gl;

//-----------------------------------------------------------------------------

float Torpedo::sScreenWidth = 0.f;
float Torpedo::sScreenHeigth = 0.f;

const Color Torpedo::sColor(1.0f, 0.0f, 0.0f);

//-----------------------------------------------------------------------------

Torpedo::Torpedo(const vec2& location, const vec2& direction)
 : mLocation(location), 
   mDirection(direction),
   mLength(0.0f)
{
}

//-----------------------------------------------------------------------------

bool Torpedo::update()
{
   if (mLength > sScreenHeigth*0.9f)
   {
      return false;
   }

   const float speed = 17.0f;
   mLocation += mDirection * speed;
   mLength += speed;

   if (mLocation[0]<0.0f)
   {
      mLocation[0] += sScreenWidth;
   }
   else if (mLocation[0]>=sScreenWidth)
   {
      mLocation[0] -= sScreenWidth;
   }

   if (mLocation[1]<0.0f)
   {
      mLocation[1] += sScreenHeigth;
   }
   else if (mLocation[1]>=sScreenHeigth)
   {
      mLocation[1] -= sScreenHeigth;
   }

   return true;
}

//-----------------------------------------------------------------------------

void Torpedo::draw() const
{
   if (mLocation[0]<Size())
   {
      Draw(mLocation+vec2(sScreenWidth, 0.0f), sColor);
   }
   else if (mLocation[0]>sScreenWidth-Size())
   {
      Draw(mLocation-vec2(sScreenWidth, 0.0f), sColor);
   }
   if (mLocation[1]<Size())
   {
      Draw(mLocation+vec2(0.0f, sScreenHeigth), sColor);
   }
   else if (mLocation[1]>sScreenHeigth-Size())
   {
      Draw(mLocation-vec2(0.0f, sScreenHeigth), sColor);
   }

   Draw(mLocation, sColor);
}

//-----------------------------------------------------------------------------

void Torpedo::Draw(const vec2& location, const Color& color)
{
   gl::color(color);
   drawSolidCircle(location, Radius());
}
