//=============================================================================

#include "cinder/gl/gl.h"
#include "Figure.h"

using namespace ci;
using namespace gl;

//-----------------------------------------------------------------------------

float Figure::sScreenWidth = 0.f;
float Figure::sScreenHeigth = 0.f;

//-----------------------------------------------------------------------------

Figure::Figure(const vec2& location, const vec2& direction)
 : mLocation(location), 
   mDirection(direction)
{
}

//-----------------------------------------------------------------------------

bool Figure::update()
{
   if (!doUpdate())
   {
      return false;
   }

   if (mLocation[0]<0.0f)
   {
      mLocation[0] += sScreenWidth;
   }
   else if (mLocation[0]>=sScreenWidth)
   {
      mLocation[0] -= sScreenWidth;
   }

   if (mLocation[1]<0.0f)
   {
      mLocation[1] += sScreenHeigth;
   }
   else if (mLocation[1]>=sScreenHeigth)
   {
      mLocation[1] -= sScreenHeigth;
   }

   return true;
}

//-----------------------------------------------------------------------------

void Figure::draw() const
{
   if (mLocation[0]<size())
   {
      doDraw(mLocation+vec2(sScreenWidth, 0.0f));
   }
   else if (mLocation[0]>sScreenWidth-size())
   {
      doDraw(mLocation-vec2(sScreenWidth, 0.0f));
   }
   if (mLocation[1]<size())
   {
      doDraw(mLocation+vec2(0.0f, sScreenHeigth));
   }
   else if (mLocation[1]>sScreenHeigth-size())
   {
      doDraw(mLocation-vec2(0.0f, sScreenHeigth));
   }

   doDraw(mLocation);
}
