//=============================================================================

#include "cinder/Color.h"
#include "cinder/gl/gl.h"
#include "ExplosionShip.h"

using namespace ci;
using namespace gl;

//-----------------------------------------------------------------------------

ExplosionShip::ExplosionShip(const vec2& location)
 : Super(location, vec2(0.f, 0.f)),
   mCounter(0)
{
}

//-----------------------------------------------------------------------------

float ExplosionShip::radius() const
{
   float res = static_cast<float>(mCounter);
   if (mCounter>50)
   {
      res = static_cast<float>(100-mCounter);
   }
   return res;
}

//-----------------------------------------------------------------------------

bool ExplosionShip::doUpdate()
{
   mCounter+=2;
   return mCounter<100;
}

//-----------------------------------------------------------------------------

void ExplosionShip::doDraw(const vec2& location) const
{
   float r = radius();
   gl::color(1.0f, 1.0f-r*0.02f, 0.0f);
   drawSolidCircle(location, r);
}
