//=============================================================================

#ifndef EXPLOSION_SHIP_H
#define EXPLOSION_SHIP_H

#include <memory>
#include "cinder/Vector.h"
#include "Figure.h"

//-----------------------------------------------------------------------------

class ExplosionShip : public Figure
{
   using Super = Figure;

public:
   explicit ExplosionShip(const ci::vec2& location);

protected:
   float radius() const;
   float size() const override { return 2*radius(); }

   bool doUpdate() override;
   void doDraw(const ci::vec2& location) const override;

private:
   int mCounter;
};

using ExplosionShipPtr = std::shared_ptr<ExplosionShip>;

//-----------------------------------------------------------------------------

#endif
