//=============================================================================

#include "cinder/Color.h"
#include "cinder/gl/gl.h"
#include "ExplosionAsteroid.h"

using namespace ci;
using namespace gl;

//-----------------------------------------------------------------------------

ExplosionAsteroid::ExplosionAsteroid(const vec2& location)
 : Super(location, vec2(0.f, 0.f)),
   mCounter(0)
{
}

//-----------------------------------------------------------------------------

float ExplosionAsteroid::radius() const
{
   float res = static_cast<float>(mCounter);
   if (mCounter>10)
   {
      res = static_cast<float>(20-mCounter);
   }
   return res;
}

//-----------------------------------------------------------------------------

bool ExplosionAsteroid::doUpdate()
{
   return ++mCounter<20;
}

//-----------------------------------------------------------------------------

void ExplosionAsteroid::doDraw(const vec2& location) const
{
   float r = radius();
   gl::color(1.0f, 1.0f-r*0.1f, 0.0f);
   gl::drawSolidCircle(location, r);
}
