//=============================================================================

#include "cinder/gl/gl.h"
#include "ExplosionShip.h"

using namespace ci;
using namespace gl;

//-----------------------------------------------------------------------------

ExplosionShip::ExplosionShip(const vec2& location)
 : Super(location, cMaxSize)
{
}

//-----------------------------------------------------------------------------

bool ExplosionShip::doUpdate()
{
   mCounter+=2;
   return mCounter<cMaxSize;
}

//-----------------------------------------------------------------------------

void ExplosionShip::doDraw(const vec2& location) const
{
   float r = radius();
   gl::color(1.0f, 1.0f-r*0.02f, 0.0f);
   drawSolidCircle(location, r);
}
