//=============================================================================

#ifndef FIGURE_H
#define FIGURE_H

#include <memory>
#include "cinder/Vector.h"

//-----------------------------------------------------------------------------

class Figure
{
public:
   static float sScreenWidth;
   static float sScreenHeigth;

   virtual ~Figure() = default;

   bool update();
   void draw() const;

protected:
   explicit Figure(const ci::vec2& location, const ci::vec2& direction);

   virtual float size() const = 0;

   virtual bool doUpdate() = 0;
   virtual void doDraw(const ci::vec2& location) const = 0;

   ci::vec2 mLocation;
   ci::vec2 mDirection;
};

//-----------------------------------------------------------------------------

#endif
