//=============================================================================

#include "cinder/gl/gl.h"
#include "cinder/Rand.h"
#include "Asteroid.h"

using namespace ci;
using namespace gl;
using namespace std;

//-----------------------------------------------------------------------------

static const float sRadius[] = { 6.0f, 12.0f, 18.0f, 24.0f };

static const Color sColor(0.5f, 0.49f, 0.51f);

//-----------------------------------------------------------------------------

static vec2 getStartLocation(Asteroid::Region region)
{
   float dx = 1.0f + randFloat(60.0f);
   float dy = 1.0f + randFloat(60.0f);

   float x,y;
   switch (region)
   {
   case Asteroid::Region::LeftTop:
      x = dx;
      y = dy;
      break;
   case Asteroid::Region::RightTop:
      x = Figure::sScreenWidth - dx;
      y = dy;
      break;
   case Asteroid::Region::LeftBottom:
      x = dx;
      y = Figure::sScreenHeigth - dy;
      break;
   case Asteroid::Region::RightBottom:
      x = Figure::sScreenWidth - dx;
      y = Figure::sScreenHeigth - dy;
      break;
   }
   return vec2(x, y);
}

//-----------------------------------------------------------------------------

static vec2 getStartDirection(Asteroid::Region region)
{
   float dx = randFloat(1.f);
   float dy = randFloat(1.f);

   float x, y;
   switch (region)
   {
   case Asteroid::Region::LeftTop:
      x = dx;
      y = dy;
      break;
   case Asteroid::Region::RightTop:
      x = -dx;
      y = dy;
      break;
   case Asteroid::Region::LeftBottom:
      x = dx;
      y = -dy;
      break;
   case Asteroid::Region::RightBottom:
      x = -dx;
      y = -dy;
      break;
   }
   return vec2(x, y);
}

//-----------------------------------------------------------------------------

Asteroid::Asteroid(Region region, Type type)
 : Super(getStartLocation(region), getStartDirection(region)),
   mType(type), mRadius(sRadius[static_cast<int>(type)]),
   mSpeed(2.0f + randFloat(4.0f))
{
}

//-----------------------------------------------------------------------------

bool Asteroid::doUpdate()
{
   mLocation += mDirection * mSpeed;
   return true;
}

//-----------------------------------------------------------------------------

void Asteroid::doDraw(const vec2& location) const
{
   gl::color(sColor);
   drawSolidCircle(location, mRadius);
}
