//=============================================================================

#ifndef TORPEDO_H
#define TORPEDO_H

#include <memory>
#include "cinder/Color.h"
#include "cinder/Vector.h"
#include "Figure.h"

//-----------------------------------------------------------------------------

class Torpedo : public Figure
{
   using Super = Figure;

public:
   explicit Torpedo(const ci::vec2& location, const ci::vec2& direction);

   static void Draw(const ci::vec2& location, const ci::Color& color);

   static float Radius() { return 2.0f; }
   static float Size() { return 2*Radius(); }

protected:
   float size() const override { return Size(); };

   bool doUpdate() override;
   void doDraw(const ci::vec2& location) const override { Draw(location, sColor); }

private:
   static const ci::Color sColor;
   float mLength;
};

using TorpedoPtr = std::shared_ptr<Torpedo>;

//-----------------------------------------------------------------------------

#endif
