//=============================================================================

#ifndef ASTEROID_H
#define ASTEROID_H

#include <memory>
#include "cinder/Color.h"
#include "cinder/Vector.h"
#include "Figure.h"

//-----------------------------------------------------------------------------

class Asteroid : public Figure
{
   using Super = Figure;

public:
   enum class Region { LeftTop, RightTop, LeftBottom, RightBottom };
   enum class Type { Small, Medium, Big, Huge };

   explicit Asteroid(Region region, Type type);

   float radius() { return mRadius; }

protected:
   float size() const override { return 2*mRadius; };

   bool doUpdate() override;
   void doDraw(const ci::vec2& location) const override;

private:
   Type mType;
   float mRadius;
   float mSpeed;
};

using AsteroidPtr = std::shared_ptr<Asteroid>;

//-----------------------------------------------------------------------------

#endif
