//=============================================================================

#ifndef ASTEROID_H
#define ASTEROID_H

#include <memory>
#include "cinder/Color.h"
#include "cinder/Vector.h"
#include "Figure.h"

//-----------------------------------------------------------------------------

class Asteroid;
using AsteroidPtr = std::shared_ptr<Asteroid>;

class Asteroid : public Figure
{
   using Super = Figure;

public:
   typedef unsigned long long Points;
   enum class Region { LeftTop, RightTop, LeftBottom, RightBottom };
   enum class Type { Small, Medium, Big, Huge };

   explicit Asteroid(Region region, Type type);
   explicit Asteroid(const ci::vec2& location, Type type);

   Points getPoints() const;

   void hit(std::vector<AsteroidPtr>&);

   float radius() { return mRadius; }

protected:
   float size() const override { return 2*mRadius; };

   bool doUpdate() override;
   void doDraw(const ci::vec2& location) const override;

private:
   Type mType;
   float mRadius;
   float mSpeed;
};

//-----------------------------------------------------------------------------

#endif
