//=============================================================================

#ifndef SHIP_H
#define SHIP_H

#include <memory>
#include "cinder/Color.h"
#include "cinder/Vector.h"
#include "Figure.h"
#include "Torpedo.h"

//-----------------------------------------------------------------------------

class Ship : public Figure
{
   using Super = Figure;

public:
   explicit Ship();

   void rotate(float degree);
   void accelerate(float accel);

   TorpedoPtr fire() const;

   static void Draw(const ci::vec2& location, const ci::vec2& direction, const ci::Color& color);

   static float Radius() { return 8.0f; }
   static float Size() { return 2*Radius(); }

protected:
   float size() const override { return Size(); };

   bool doUpdate() override;
   void doDraw(const ci::vec2& location) const override { Draw(location, mDirection, sColor); }

private:
   static const ci::Color sColor;
   float mSpeed;
};

using ShipPtr = std::shared_ptr<Ship>;

//-----------------------------------------------------------------------------

#endif
