//=============================================================================

#include <iostream>
#include <limits>
#include <string>
#include <vector>
using namespace std;

//-----------------------------------------------------------------------------

class Hanoi
{
public:
   Hanoi(int count)
    : countSlices(count)
   {
      initTower1();
   }

   void simulate();

private:
   void printEmptyLine();
   [[nodiscard]] bool sliceExistsInThisLevel(const vector<int>& tower, int level);  
   void printSlice(int slice);
   void printNoSlice();
   void printTowerOnLevel(const vector<int>& tower, int level);
   void printTowerLevel(int level);
   void printOnlyTowers();
   void printBasePlate();
   void printTower();
   void initTower1();
   void moveSlice(vector<int>& src, vector<int>& dest);
   void moveTower(vector<int>& src, vector<int>& dest, vector<int>& util, int count);

   vector<int> tower1;
   vector<int> tower2;
   vector<int> tower3;

   int countSlices;
   int counter = 1;
};

//-----------------------------------------------------------------------------

void Hanoi::printEmptyLine()
{
   cout << '\n';
}

//-----------------------------------------------------------------------------

[[nodiscard]] bool Hanoi::sliceExistsInThisLevel(const vector<int>& tower, int level)
{
   return level < tower.size();
}

//-----------------------------------------------------------------------------

void Hanoi::printSlice(int slice)
{
   const int spaces = countSlices - slice;
   const string sspaces(spaces, ' ');
   const string sslice(slice, '-');
   cout << sspaces << sslice << '|' << sslice << sspaces;
}

//-----------------------------------------------------------------------------

void Hanoi::printNoSlice()
{
   const string sspaces(countSlices, ' ');
   cout << sspaces << '|' << sspaces;
}

//-----------------------------------------------------------------------------

void Hanoi::printTowerOnLevel(const vector<int>& tower, int level)
{
   if (sliceExistsInThisLevel(tower, level))
   {
      const int slice = tower[level];
      printSlice(slice);
      return;
   }
   printNoSlice();
}

//-----------------------------------------------------------------------------

void Hanoi::printTowerLevel(int level)
{
   cout << ' ';
   printTowerOnLevel(tower1, level);
   cout << ' ';
   printTowerOnLevel(tower2, level);
   cout << ' ';
   printTowerOnLevel(tower3, level);
   cout << '\n';
}

//-----------------------------------------------------------------------------

void Hanoi::printOnlyTowers()
{
   for (int level = countSlices - 1; level >= 0; --level)
   {
      printTowerLevel(level);
   }
}

//-----------------------------------------------------------------------------

void Hanoi::printBasePlate()
{
   const string base(6 * countSlices + 7, '=');
   cout << base << '\n';
}

//-----------------------------------------------------------------------------

void Hanoi::printTower()
{
   printEmptyLine();
   cout << counter << ".\n";
   printOnlyTowers();
   printBasePlate();
}

//-----------------------------------------------------------------------------

void Hanoi::initTower1()
{
   for (int i = countSlices; i > 0; --i)
   {
      tower1.push_back(i);
   }
}

//-----------------------------------------------------------------------------

void Hanoi::moveSlice(vector<int>& src, vector<int>& dest)
{
   const int slice = src.back();
   src.pop_back();
   dest.push_back(slice);

   ++counter;
   printTower();
}

//-----------------------------------------------------------------------------

void Hanoi::moveTower(vector<int>& src, vector<int>& dest, vector<int>& util, int count)
{
   if (count == 1)
   {
      moveSlice(src, dest);
      return;
   }
   moveTower(src, util, dest, count - 1);
   moveSlice(src, dest);
   moveTower(util, dest, src, count - 1);
}

//-----------------------------------------------------------------------------

void Hanoi::simulate()
{
   printTower();
   moveTower(tower1, tower3, tower2, countSlices);
}

//-----------------------------------------------------------------------------

int askUserForCountSlices()
{
   for (int count = 0;;)
   {
      cout << "Lieber Nutzer, mit wie vielen Scheiben willst du spielen: ";
      cin >> count;
      if (cin && count > 0 && count < 11)
      {
         return count;
      }
      cout << "Bitte Wert von 1..10 eingeben\n";
      cin.clear();
      cin.ignore(numeric_limits<streamsize>::max(), '\n');
   }
}

//-----------------------------------------------------------------------------

int main()
{
   cout << "Tuerme von Hanoi 2\n\n";

   const int count = askUserForCountSlices();
   Hanoi hanoi(count);
   hanoi.simulate();
}
