#ifndef BOARD_HPP     // Header guard
#define BOARD_HPP

#include <array>
#include "move.hpp"

class Board
{
public:
   Board();     // Standard-Konstruktor

   void display() const;   // Spielfeld anzeigen

   bool isOccupied(int row, int col) const;

   void set(const Move& move);

   bool hasWin(GameColor gc) const;
   bool isFull() const;

private:
   enum class FieldState { Empty, White, Black };

   static FieldState convertToFieldState(GameColor gc)
   {
      return gc == GameColor::White ? FieldState::White : FieldState::Black;
   }

   // Datenstruktur fuer das Spielfeld (3x3)
   std::array<std::array<FieldState, 3>, 3> mFields;     // mFields[row][col]
};

#endif
