//=============================================================================

#include <iostream>
#include "board.hpp"
#include "computerfff.hpp"
#include "human.hpp"
using namespace std;

//-----------------------------------------------------------------------------
// Pseudo code / Algorithmus

int main()
{
   cout << "Uebung 08 - Aufgabe 14.6 - Tic-Tac-Toe 1\n\n";

   // 1. Spielfeld initialisieren
   // - Fuer die erste Version haben wir keine Spielerklassen
   Board board;

   // 2. Spielfeld anzeigen
   board.display();

   // 3. Spielschleife
   for (;;)
   {
      // 4. Spieler 1 (Mensch) nach seinem Zug fragen
      Move move = askHumanForMove(board);

      // 5. Zug durchfuehren (+ Ausgabe)
      cout << "\nMensch macht Zug: ";
      move.display();
      cout << '\n';
      board.set(move);

      // 6. Spielfeld anzeigen
      board.display();

      // 7. Pruefen ob Spieler 1 gewonnen hat
      if (board.hasWin(move.getGameColor()))
      {
         cout << "\nMensch hat gewonnen\n";
         break;
      }

      // 8. Pruefen ob unentschieden (Spielfeld voll) ist
      if (board.isFull())
      {
         cout << "\nRemis\n";
         break;
      }

      // 9. Spieler 2 (Computer) nach seinem Zug fragen
      move = askComputerFFFForMove(board);

      // 10. Zug durchfuehren (+ Ausgabe)
      cout << "\nComputer-FFF macht Zug: ";
      move.display();
      cout << '\n';
      board.set(move);

      // 11. Spielfeld anzeigen
      board.display();

      // 12. Pruefen ob Spieler 2 gewonnen hat
      if (board.hasWin(move.getGameColor()))
      {
         cout << "\nComputer-FFF hat gewonnen\n";
         break;
      }

      // 13. Pruefen ob unentschieden (Spielfeld voll) ist - nicht notwendig, kann nicht passieren

      // 14. Ende Spielschleife - springe zu 3
   }
}
