//=============================================================================
// Ein alternative Loesung, die aber langsamer waere, ware den
// eingelesenen Integer in einen String (siehe Kapitel 9)
// zu wandeln, und dann auf diesem zu arbeiten.

#include <iostream>
using namespace std;

//-----------------------------------------------------------------------------

int main()
{
   cout << "Aufg_08_07_Zahlen_Zerlegung\n\n";

   cout << "Eingabe: ";

   int input;
   cin >> input;
   if (cin.fail() || input < 0)
   {
      cout << "Fehlerhafte Eingabe\n";
      return 0;
   }

   // Wie viele Stellen hat der Integer?
   // Ginge einfach mit dem Logarithmus - siehe Kapitel 13
   int len = 1;
   int value = input;
   while ((value /= 10) > 0) ++len;

   // Teiler zum Abtrennen der ersten Ziffer berechnen
   // Ginge wieder einfacher mit Potenzen - siehe Kapitel 13
   int divider = 1;
   for (int i = 0; i < len-1; ++i) divider *= 10;

   // Zahl in ihre Ziffern von vorne auftrennen und ausgeben
   for (;;)
   {
      const int digit = input / divider;
      cout << digit;
      input %= divider;
      divider /= 10;
      if (divider == 0)
      {
         break;
      }
      cout << '-';
   }
   cout << '\n';
}
