//=============================================================================

#include <iostream>
#include <string>
using namespace std;

//-----------------------------------------------------------------------------

int main()
{
   cout << "Aufg_09_05_EAN_Pruefung\n\n";


   cout << "Bitte geben Sie eine EAN-13 ein: ";

   string ean;
   getline(cin, ean);
   cout << '\n';

   auto pos = ean.find_first_not_of("1234567890 -");
   if (pos != string::npos)
   {
      cout << "Fehlerhaftes Zeichen in der EAN an Position " << (pos + 1) << '\n';
      return 0;
   }

   // Trennzeichen aus der EAN entfernen
   string::size_type write_pos = 0;
   for (string::size_type read_pos = 0; read_pos < ean.length(); ++read_pos)
   {
      char c = ean[read_pos];
      if (c == ' ' || c == '-') continue;
      ean[write_pos++] = c;
   }
   ean.erase(write_pos);

   const auto len = ean.length();
   if (len != 13)
   {
      cout << "Fehlerhafte Laenge (" << len << ") der EAN\n";
      return 0;
   }

   const int sum1 = ean[0] + ean[2] + ean[4] + ean[6] + ean[8] + ean[10] - 6 * '0';
   const int sum2 = ean[1] + ean[3] + ean[5] + ean[7] + ean[9] + ean[11] - 6 * '0';
   const int sum = sum1 + 3 * sum2;
   const int check_digit = 10 - (sum % 10);

   if ((ean[12] - '0') == check_digit)
   {
      cout << "Die Pruefziffer " << ean[12] << " ist korrekt\n";
   }
   else
   {
      cout << "Die Pruefziffer " << ean[12] << " ist NICHT korrekt\n";
      cout << "Korrekt ist die Ziffer: " << check_digit << '\n';
   }
}
