//=============================================================================

#include <iostream>
#include <string>
using namespace std;

//-----------------------------------------------------------------------------

int main()
{
   cout << "Aufg_09_07_Caesar_Verschluesselung_1\n\n";

   cout << "Text: ";
   string input;
   getline(cin, input);

   if (input.empty() || string::npos != input.find_last_not_of("abcdefghijklmnopqrstuvwxyz "))
   {
      cout << "Fehlerhafte Eingabe\n";
      return 0;
   }

   cout << "Schluessel: ";
   int key;
   cin >> key;
   if (cin.fail() || key < 1 || key > 25)
   {
      cout << "Fehlerhafte Eingabe\n";
      return 0;
   }

   cout << "(v)er - oder (e)ntschluesselung: ";
   char choice;
   cin >> choice;
   if (choice != 'v' && choice != 'e')
   {
      cout << "Fehlerhafte Eingabe\n";
      return 0;
   }

   if (choice == 'v')
   {
      string res;
      res.reserve(input.length());

      // Achtung - arbeiten Sie hier nicht mit "char"
      // Denn "char" kann "signed" sein - und ein 'z' hat den ASCII Code 122
      // Und dann kann "c += key" ueber die 8 Bit Signed-Grenze von 127 springen
      for (unsigned char c : input)
      {
         if (c == ' ')
         {
            res += ' ';
            continue;
         }

         c += key;
         if (c > 'z')
         {
            c -= 26;
         }
         res += c;
      }
      cout << "=> " << res << '\n';
      return 0;
   }

   string res;
   res.reserve(input.length());

   for (char c : input)
   {
      if (c == ' ')
      {
         res += ' ';
         continue;
      }

      c -= key;
      if (c < 'a')
      {
         c += 26;
      }
      res += c;
   }
   cout << "=> " << res << '\n';
}
