//=============================================================================

#include <iomanip>
#include <iostream>
using namespace std;

//-----------------------------------------------------------------------------

double const epsilon = 0.0001;

//-----------------------------------------------------------------------------

template<class T> T square_root(T v, const T epsilon)
{
   T lower_limit = 1.0;
   T upper_limit = v;
   T average;
   for (;;)
   {
      average = (lower_limit + upper_limit) / 2;
      double av2 = average * average;
      if ((av2 - epsilon < v) && (av2 + epsilon > v)) break;
      if (v < av2)
      {
         upper_limit = average;
         continue;
      }
      lower_limit = average;
   }
   return average;
}

//-----------------------------------------------------------------------------

int main()
{
   cout << "Aufg_12_06_Quadratwurzel_2_V2\n\n";

   cout << "sq(4.0f):  " << setprecision(10) << square_root(4.f, 0.001f) << '\n';
   cout << "sq(4.0d):  " << setprecision(10) << square_root(4.0, 0.00001) << '\n';
   cout << "sq(4.0ld): " << setprecision(10) << square_root(4.l, 0.0000001l) << '\n';
}
