//=============================================================================

#include <array>
#include <iostream>
#include <iomanip>
#include <string>
using namespace std;

//-----------------------------------------------------------------------------

array<char, 36> const digits =
{
   '0', '1', '2', '3', '4', '5', '6', '7', '8', '9',
   'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j',
   'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't',
   'u', 'v', 'w', 'x', 'y', 'z'
};

//-----------------------------------------------------------------------------

string as_string_rec(unsigned int v, unsigned int base)
{
   unsigned int mod = v % base;
   string res(1, digits[mod]);

   unsigned int div = v / base;
   if (div == 0)
   {
      return res;
   }

   res = as_string_rec(div, base) + res;
   return res;
}

//-----------------------------------------------------------------------------

string as_string(unsigned int v, unsigned int base = 10)
{
   if (base < 2 || base>36)
   {
      return "---";
   }
   return as_string_rec(v, base);
}

//-----------------------------------------------------------------------------

int main()
{
   cout << "Aufg_12_07_Zahlen_Wandlung_V2 (rekursiv)\n\n";

   for (int i = 1; i < 40; ++i)
   {
      cout << "43 zur Basis " << setw(2) << i << " => " << as_string(43, i) << '\n';
   }
}
