//=============================================================================

#include <iostream>
#include <optional>
#include <string>
using namespace std;

//-----------------------------------------------------------------------------

optional<string> readInputText()
{
   cout << "Text: ";
   string input;
   getline(cin, input);

   if (input.empty() || string::npos != input.find_last_not_of("abcdefghijklmnopqrstuvwxyz "))
   {
      cout << "Fehlerhafte Eingabe\n";
      return {};
   }
   return input;
}

//-----------------------------------------------------------------------------

optional<int> readKey()
{
   cout << "Schluessel: ";
   int key;
   cin >> key;
   if (cin.fail() || key < 1 || key > 25)
   {
      cout << "Fehlerhafte Eingabe\n";
      return {};
   }
   return key;
}

//-----------------------------------------------------------------------------

enum class Choice { crypt, decrypt };

optional<Choice> readChoice()
{
   cout << "(v)er - oder (e)ntschluesselung: ";
   char choice;
   cin >> choice;
   switch (choice)
   {
   case 'v':
      return Choice::crypt;
   case 'e':
      return Choice::decrypt;
   }
   cout << "Fehlerhafte Eingabe\n";
   return {};
}

//-----------------------------------------------------------------------------

string crypt(int key, const string& in)
{
   string res;
   res.reserve(in.length());

   // Achtung - arbeiten Sie hier nicht mit "char"
   // Denn "char" kann "signed" sein - und ein 'z' hat den ASCII Code 122
   // Und dann kann "c += key" ueber die 8 Bit Signed-Grenze von 127 springen
   for (unsigned char c : in)
   {
      if (c == ' ')
      {
         res += 'a' + key - 1;
         continue;
      }

      c += key;
      if (c == 'z' + 1)
      {
         c = ' ';
      }
      else if (c > 'z' + 1)
      {
         c -= 27;
      }
      res += c;
   }

   return res;
}

//-----------------------------------------------------------------------------

string decrypt(int key, const string& in)
{
   string res;
   res.reserve(in.length());

   for (char c : in)
   {
      if (c == ' ')
      {
         res += 'z' - key + 1;
         continue;
      }

      c -= key;
      if (c == 'a' - 1)
      {
         c =  ' ';
      }
      else if (c < 'a' - 1)
      {
         c += 27;
      }
      res += c;
   }

   return res;
}

//-----------------------------------------------------------------------------

int main()
{
   cout << "Aufg_12_13_Caesar_Verschluesselung_2\n\n";

   auto otext = readInputText();
   if (!otext)
   {
      return 0;
   }
   string text = *otext;

   auto okey = readKey();
   if (!okey)
   {
      return 0;
   }
   int key = *okey;

   auto ochoice = readChoice();
   if (!ochoice)
   {
      return 0;
   }
   Choice choice = *ochoice;

   if (choice == Choice::crypt)
   {
      string res = crypt(key, text);
      cout << "=> " << res << '\n';
      return 0;
   }

   string res = decrypt(key, text);
   cout << "=> " << res << '\n';
}
