//=============================================================================

#include <iostream>
#include <random>
using namespace std;

//-----------------------------------------------------------------------------

int main()
{
   cout << "Aufg_13_06_Pi_Simulieren\n\n";

   const int count = 10000;

   random_device rd;
   mt19937 generator(rd());
   uniform_real_distribution<> distribution(-1., 1.);

   int hits = 0;
   for (int i = 0; i < count; ++i)
   {
      const double x = distribution(generator);
      const double y = distribution(generator);
      const double r_square = x * x + y * y;
      if (r_square <= 1)
      {
         ++hits;
      }
   }

   const double pi = static_cast<double>(4 * hits) / count;
   cout << count << " Durchlaeufe => Pi: " << pi << endl;
}
