//=============================================================================

#include <array>
#include <iostream>
#include <limits>
#include <string>
using std::array;
using std::cin;
using std::cout;
using std::numeric_limits;
using std::streamsize;
using std::string;

//-----------------------------------------------------------------------------

enum class color { white, black };

//-----------------------------------------------------------------------------

class move
{
public:
   move(int x, int y, color c) : x_(x), y_(y), color_(c) {}
   move(int f, color c) : x_(f/3), y_(f%3), color_(c) {}

   int x() const { return x_; }
   int y() const { return y_; }

   color get_color() const { return color_; }

   void print() const;

private:
   int x_;
   int y_;
   color color_;
};

//-----------------------------------------------------------------------------

class board
{
public:
   board();

   bool valid(const move& m) const { return field_[m.x()][m.y()] == state::empty; }

   void set(const move& m) { field_[m.x()][m.y()] = convert(m.get_color()); }

   bool full() const;
   bool wins(color) const;

   void print() const;

private:
   enum class state { white = static_cast<int>(color::white), black = static_cast<int>(color::black), empty };

   static state convert(color c) { return static_cast<state>(c); }

   using line = array<state, 3>;
   using field = array<line, 3>;
   field field_;
};

//-----------------------------------------------------------------------------

class human
{
public:
   human(color c) : color_(c) {}

   move next(const board&);

   color get_color() const { return color_; }
   string name() const { return "Mensch"; }

private:
   color color_;
};

//-----------------------------------------------------------------------------

class computer
{
public:
   computer(color c) : color_(c) {}

   move next(const board&);

   color get_color() const { return color_; }
   string name() const { return "Computer"; }

private:
   color color_;
};

//-----------------------------------------------------------------------------

void move::print() const
{
   cout << x_ + 1 << '/' << y_ + 1 << ':' << (color_ == color::white ? 'w' : 's');
}

//-----------------------------------------------------------------------------

board::board()
{
   line l = { state::empty, state::empty, state::empty };
   field_ = { l, l, l };
}

//-----------------------------------------------------------------------------

bool board::full() const
{
   for (const line& l : field_)
   {
      for (state s: l)
      {
         if (s == state::empty) return false;
      }
   }
   return true;
}

//-----------------------------------------------------------------------------

bool board::wins(color c) const
{
   state s = convert(c);
   if (field_[0][0] == s && field_[0][1] == s && field_[0][2] == s) return true;
   if (field_[1][0] == s && field_[1][1] == s && field_[1][2] == s) return true;
   if (field_[2][0] == s && field_[2][1] == s && field_[2][2] == s) return true;
   if (field_[0][0] == s && field_[1][0] == s && field_[2][0] == s) return true;
   if (field_[0][1] == s && field_[1][1] == s && field_[2][1] == s) return true;
   if (field_[0][2] == s && field_[1][2] == s && field_[2][2] == s) return true;
   if (field_[0][0] == s && field_[1][1] == s && field_[2][2] == s) return true;
   if (field_[0][2] == s && field_[1][1] == s && field_[2][0] == s) return true;
   return false;
}

//-----------------------------------------------------------------------------

void board::print() const
{
   for (const line& l : field_)
   {
      for (state s : l)
      {
         switch (s)
         {
         case state::empty:
            cout << '_';
            break;
         case state::white:
            cout << 'O';
            break;
         case state::black:
            cout << 'X';
            break;
         }
      }
      cout << '\n';
   }
   cout << '\n';
}

//-----------------------------------------------------------------------------

move human::next(const board& b)
{
   for (;;)
   {
      cout << "\nBitte machen Sie Ihren Zug (1..9): ";

      char c;
      cin >> c;
      if (cin.fail() || c < '1' || c>'9')
      {
         cout << "Fehlerhafte Eingabe!\n\n";
         cin.clear();
         cin.ignore(numeric_limits<streamsize>::max(), '\n');
         continue;
      }
      cin.ignore(numeric_limits<streamsize>::max(), '\n');

      move m(c - '0' - 1, color_);
      if (b.valid(m))
      {
         cout << '\n';
         return m;
      }
      cout << "Feld schon besetzt!\n\n";
   }
}

//-----------------------------------------------------------------------------

move computer::next(const board& b)
{
   for (int i = 0; ; ++i)
   {
      for (int j = 0; j < 3; ++j)
      {
         move m(i, j, color_);
         if (b.valid(m))
         {
            return m;
         }
      }
   }
   // <-- keine Rueckgabe noetig, da man hier nicht hinkommen kann   
}

//-----------------------------------------------------------------------------

int main()
{
   cout << "Aufg_14_06_Tic_Tac_Toe_1\n\n";

   board b;
   human pl1(color::white);
   computer pl2(color::black);

   b.print();

   for (;;)
   {
      move m = pl1.next(b);

      cout << '\n' << pl1.name() << " macht Zug: ";
      m.print();
      cout << "\n\n";

      b.set(m);
      b.print();

      if (b.wins(pl1.get_color()))
      {
         cout << '\n' << pl1.name() << " hat gewonnen\n";
         return 0;
      }
      if (b.full())
      {
         cout << "\nDas Spiel ist remis ausgegangen\n";
         return 0;
      }

      m = pl2.next(b);
      cout << '\n' << pl2.name() << " macht Zug: ";
      m.print();
      cout << "\n\n";

      b.set(m);
      b.print();

      if (b.wins(pl2.get_color()))
      {
         cout << '\n' << pl2.name() << " hat gewonnen\n";
         return 0;
      }
   }
}
