//=============================================================================

#include <iostream>
#include "entry.h"
#include "utils.h"
using namespace std;

//-----------------------------------------------------------------------------

void entry::edit()
{
   cout << "- Name:    " << name_
      << "\n- Strasse: " << street_
      << "\n- Ort:     " << town_
      << "\n- Nummern:";
   if (numbers_.empty())
   {
      cout << " ---\n";
   }
   else
   {
      auto it = cbegin(numbers_);
      auto eit = cend(numbers_);
      for (bool first = true; it != eit; ++it, first = false)
      {
         cout << (first ? " " : "           ") << *it << '\n';
      }
   }

   string_edit("den Namen", "Neuer Name", name_);
   string_edit("die Strasse", "Neue Strasse", street_);
   string_edit("den Ort", "Neuer Ort", town_);

   if (ask_yes_no("Wollen Sie neue Nummern eingeben?"))
   {
      numbers_.clear();
      cout << "Neue Nummern:\n";
      for (string no;;)
      {
         cout << "> Nr.: ";
         getline(cin, no);
         if (no.empty()) break;
         numbers_.push_back(no);
      }
   }
}

//-----------------------------------------------------------------------------

void entry::input(string const& name)
{
   name_ = name;

   cout << "> Strasse: ";
   getline(cin, street_);

   cout << "> Ort: ";
   getline(cin, town_);

   for (string no;;)
   {
      cout << "> Nr.: ";
      getline(cin, no);
      if (no.empty()) break;
      numbers_.push_back(no);
   }
}

//-----------------------------------------------------------------------------

void entry::print() const
{
   cout << "* " << name_
      << ", " << street_
      << ", " << town_
      << " => ";
   if (numbers_.empty())
   {
      cout << " ---";
   }
   else
   {
      for (const string& no : numbers_)
      {
         cout << '(' << no << ") ";
      }
   }
   cout << '\n';
}

//-----------------------------------------------------------------------------

void entry::load(ifstream& in, int& line)
{
   string name, street, town;

   ++line;
   getline(in, name);
   if (in.fail()) return;

   ++line;
   getline(in, street);
   if (in.fail()) return;

   ++line;
   getline(in, town);
   if (in.fail()) return;

   name_ = name;
   street_ = street;
   town_ = town;

   for (string no;;)
   {
      ++line;
      getline(in, no);
      // Bei s.empty() Schleife beenden, da eine Leerzeile 
      // das Ende der Telefon-Nummern anzeigt.
      if (in.fail() || no.empty()) break;
      numbers_.push_back(no);
   }
}

//-----------------------------------------------------------------------------

void entry::write(ofstream& out) const
{
   out << name_ << '\n'
      << street_ << '\n'
      << town_ << '\n';

   for (const string& no : numbers_)
   {
      out << no << '\n';
   }
   out << '\n';
}
