//=============================================================================

#include <algorithm>
#include <cctype>
#include <iostream>
#include "utils.h"
using namespace std;

//-----------------------------------------------------------------------------

bool starts_with(const string& src, const string& pattern)
{
   if (src.length() < pattern.length())
   {
      return false;
   }
   return src.substr(0, pattern.length()) == pattern;
}

//-----------------------------------------------------------------------------
// Achtung: "std::tolower" funktioniert nur mit den amerikanischen Zeichen "A-Z",
// und nicht mit zum Beispiel Umlauten.

string to_lower(const string& s)
{
   string res(s.length(), ' ');
   transform(cbegin(s), cend(s), begin(res), [](unsigned char c) { return static_cast<char>(tolower(c)); });
   return res;
}

//-----------------------------------------------------------------------------

bool ask_yes_no(const string& question)
{
   for (string s;;)
   {
      cout << '\n' << question << "\n> ";
      getline(cin, s);
      if (s.length() != 1) continue;
      char c = s[0];
      if (c == 'n')
      {
         return false;
      }
      if (c == 'j')
      {
         return true;
      }
   }
}

//-----------------------------------------------------------------------------

void string_edit(const string& title, const string& label, string& value)
{
   if (ask_yes_no("Wollen Sie " + title + " \"" + value + "\" bearbeiten?"))
   {
      cout << label << ": ";
      getline(cin, value);
   }
}
