//=============================================================================

#ifndef HANOI_H
#define HANOI_H

#include <vector>

//-------------------------------------------------------------------------------

class Hanoi
{
public:
   Hanoi(int);

   void play();
   void print() const;

private:
   using tower = std::vector<int>;
   using size = tower::size_type;

   void move_slice(tower& source, tower& dest);
   void move_tower(size layer, tower& source, tower& dest, tower& help);
   void print_tower_layer(const tower& t, int layer) const;

   tower tower1, tower2, tower3;
   int count;
   int move = 0;
};

//-------------------------------------------------------------------------------

#endif
