//=============================================================================

#include <iomanip>
#include <iostream>
#include <string>
#include "person.h"
#include "village.h"
using namespace std;

//-----------------------------------------------------------------------------

int read_int(const string& msg, int lower_limit)
{
   int res;
   for (;;)
   {
      cout << "- " << msg << ": ";
      cin >> res;
      if (!cin.fail() && res >= lower_limit) break;
      cin.clear();
      cin.ignore(numeric_limits<streamsize>::max(), '\n');
   }
   return res;
}

//-----------------------------------------------------------------------------

void print_line(const int width, const int n, const village& v)
{
   cout << setw(width) << n << ": ";
   v.print();
   cout << '\n';
}

//-----------------------------------------------------------------------------

int main()
{
   cout << "Aufg_15_04_Geruechtekueche_2\n\n";

   cout << "Geruechtekueche\n";

   int count = read_int("Anzahl Personen", 2);
   int loops = read_int("Max Durchlaeufe", 1);

   cout << '\n';


   village v(count);
   const int loops_output_width = static_cast<int>(log10(static_cast<double>(loops))) + 1;
   print_line(loops_output_width, 0, v);

   for (int i = 1; i <= loops; ++i)
   {
      if (v.next())
      {
         print_line(loops_output_width, i, v);
         if (v.stable_state()) break;
      }
   }

   cout << "\nEnde wegen "
      << (v.stable_state() ? "stabilen Zustands" : "Erreichen der max. Durchlaeufe")
      << '\n';
}
