//=============================================================================

#include <iostream>
#include "board.h"
using std::cout;

//-----------------------------------------------------------------------------

board::board()
{
   line l = { state::empty, state::empty, state::empty };
   field_ = { l, l, l };
}

//-----------------------------------------------------------------------------

bool board::full() const
{
   for (const line& l : field_)
   {
      for (state s: l)
      {
         if (s == state::empty) return false;
      }
   }
   return true;
}

//-----------------------------------------------------------------------------

bool board::wins(color c) const
{
   state s = convert(c);
   if (field_[0][0] == s && field_[0][1] == s && field_[0][2] == s) return true;
   if (field_[1][0] == s && field_[1][1] == s && field_[1][2] == s) return true;
   if (field_[2][0] == s && field_[2][1] == s && field_[2][2] == s) return true;
   if (field_[0][0] == s && field_[1][0] == s && field_[2][0] == s) return true;
   if (field_[0][1] == s && field_[1][1] == s && field_[2][1] == s) return true;
   if (field_[0][2] == s && field_[1][2] == s && field_[2][2] == s) return true;
   if (field_[0][0] == s && field_[1][1] == s && field_[2][2] == s) return true;
   if (field_[0][2] == s && field_[1][1] == s && field_[2][0] == s) return true;
   return false;
}

//-----------------------------------------------------------------------------

void board::print() const
{
   for (const line& l : field_)
   {
      for (state s : l)
      {
         switch (s)
         {
         case state::empty:
            cout << '_';
            break;
         case state::white:
            cout << 'O';
            break;
         case state::black:
            cout << 'X';
            break;
         }
      }
      cout << '\n';
   }
   cout << '\n';
}
