//=============================================================================

#ifndef FRUIT_H
#define FRUIT_H

#include <ostream>
#include <string>

//-----------------------------------------------------------------------------

class fruit
{
public:
   fruit(const std::string& name) : name_(name) {}
   virtual ~fruit() = default;

   virtual std::ostream& print(std::ostream& out) const = 0;

protected:
   const std::string& name() const { return name_; }

private:
   std::string name_;
};

inline std::ostream& operator<<(std::ostream& out, const fruit& fr)
{
   return fr.print(out);
}

//-----------------------------------------------------------------------------

#endif
