//=============================================================================

#include "board.h"
#include "computer_random.h"
using std::random_device;
using std::string;

//-----------------------------------------------------------------------------

random_device computer_random::rd;

//-----------------------------------------------------------------------------

computer_random::computer_random(const string& n, color c)
  : player(n, c), engine(rd()), dist(0, 8)
{
}

//-----------------------------------------------------------------------------

move computer_random::next(const board& b)
{
   for (;;)
   {
      move m(dist(engine), get_color());
      if (b.valid(m))
      {
         return m;
      }
   }
   // <-- keine Rueckgabe noetig, da man hier nicht hinkommen kann   
}
