//=============================================================================

#ifndef COMPUTER_RANDOM_H
#define COMPUTER_RANDOM_H

#include <string>
#include <random>
#include "move.h"
#include "player.h"

class board;

//-----------------------------------------------------------------------------

class computer_random : public player
{
public:
   computer_random(const std::string& n, color c);

   move next(const board&) override;

private:
   static std::random_device rd;
   std::mt19937 engine;
   std::uniform_int_distribution<> dist;
};

//-----------------------------------------------------------------------------

#endif
