//=============================================================================

#ifndef PLAYER_H
#define PLAYER_H

#include <iostream>
#include <string>
#include "move.h"

class board;

//-----------------------------------------------------------------------------

class player
{
public:
   player(const std::string& n, color c) : name_(n), color_(c) {}
   virtual ~player() = default;

   virtual move next(const board&) = 0;

   color get_color() const { return color_; }

   friend inline std::ostream& operator<<(std::ostream& out, const player& pl)
   {
      return out << pl.name_;
   }

private:
   std::string name_;
   color color_;
};

//-----------------------------------------------------------------------------

#endif
