//=============================================================================

#include <iostream>
#include <string>
#include "bl/answer.h"
#include "ui/question.h"
using namespace std;

//-----------------------------------------------------------------------------

namespace ui
{

   //--------------------------------------------------------------------------

   bool get_yes_no()
   {
      for (string in;;)
      {
         cout << "- (j/n): ";
         getline(cin, in);
         if (in.length() != 1) continue;
         if (in[0] == 'j') return true;
         if (in[0] == 'n') return false;
      }
   }

   //--------------------------------------------------------------------------

   class progress_bar : public bl::progress
   {
   public:
      void step(double d) override 
      { 
         if (d < 0.) d = 0.;
         if (d > 100.) d = 100.;
         auto v = static_cast<string::size_type>(d);
         string pipes(v/2, '|');
         cout << pipes << ' ' << v << "%\n";
      }
   };

   //--------------------------------------------------------------------------

   void ask_question()
   {
      cout << "Wollen Sie die ultimative Antwort wissen?\n";
      if (!get_yes_no())
      {
         cout << "\nOkay, dann nicht\n";
         return;
      }
      cout << "\nDann wollen wir mal sehen, was sich machen laesst.\n\n";

      progress_bar pgb;
      int res = bl::answer(pgb);

      cout << "\nDie Antwort ist: " << res << '\n';
   }

   //--------------------------------------------------------------------------

}
